<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * 	Classe che gestisce le modifiche alle impostazioni di Geecom
    */

    class GestoreImpostazioni {
        private $db;
        
        public function __construct($db) {
            $this->db = $db;
        }
        
        public function aggiornaImpoastazioniCookie($id,$attivaBarraCookie,$durataCookie,$testoBarraCookie,$testoPulsanteAccetto,$testoPulsanteNonAccetto,$testoPulsanteMaggioriInformazioni,$headCodiciCookie,$fineBodyCookie,$mostraPulsanteMaggioriInformazioni,$mostraPulsanteNonAccetto,$paginaMaggioriInformazioni) {
            $query = "UPDATE geecB_leggeCookie SET attivaBarraCookie='$attivaBarraCookie', durataCookie='$durataCookie', testoBarraCookie='$testoBarraCookie', testoPulsanteAccetto='$testoPulsanteAccetto', testoPulsanteNonAccetto='$testoPulsanteNonAccetto', headCodiciCookie='$headCodiciCookie', fineBodyCookie='$fineBodyCookie', testoPulsanteMaggioriInformazioni='$testoPulsanteMaggioriInformazioni', mostraPulsanteMaggioriInformazioni='$mostraPulsanteMaggioriInformazioni', mostraPulsanteNonAccetto='$mostraPulsanteNonAccetto', paginaMaggioriInformazioni=$paginaMaggioriInformazioni WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function aggiornaCampoTabella($tabella,$id,$campo,$valore) {
            $query = "UPDATE $tabella SET $campo = '$valore' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function incrementaClickInvitoAzione($id) {
            $invitoAzione = $this->db->leggiSingolaRiga("geec_invitiAzione",$id);
            $conteggioAggiornato  = $invitoAzione["numeroClick"] +1;
            $dataClick = date("Y-m-d H:i");
            $query = "UPDATE geec_invitiAzione SET numeroClick = '$conteggioAggiornato', dataUltimoClick='$dataClick' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function incrementaClickSlide($id) {
            $slide = $this->db->leggiSingolaRiga("geec_slide",$id);
            $conteggioAggiornato  = $slide["numeroClick"] +1;
            $dataClick = date("Y-m-d H:i");
            $query = "UPDATE geec_slide SET numeroClick = '$conteggioAggiornato', dataUltimoClick='$dataClick' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function incrementaClickColonnaTabellaPrezzi($id) {
            $colonnaTabellaPrezzi = $this->db->leggiSingolaRiga("geec_colonneTabellaPrezzi",$id);
            $conteggioAggiornato  = $colonnaTabellaPrezzi["numeroClick"] +1;
            $dataClick = date("Y-m-d H:i");
            $query = "UPDATE geec_colonneTabellaPrezzi SET numeroClick = '$conteggioAggiornato', dataUltimoClick='$dataClick' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
       /*
        * l'aggiornamento viene fatto per la singola campagna
        */
        public function incrementaClickBanner($idCampagna) {
            $invitoAzione = $this->db->leggiSingolaRiga("geec_campagneBanner",$idCampagna);
            
            $dataClick = date("Y-m-d H:i");
            $datetime1 = date_create($dataClick);
            $datetime2 = date_create($invitoAzione["dataUltimoClick"]);
            $interval = date_diff($datetime1, $datetime2);
            $differenzaInGiorniDaUltimoClick = $interval->format("%d");
            if($differenzaInGiorniDaUltimoClick==0) {
                $conteggioGiornalieroAggiornato  = $invitoAzione["numeroClickOggi"] +1;
            }
            else {
                $conteggioGiornalieroAggiornato  = 1;
            }
            $conteggioTotaleAggiornato  = $invitoAzione["numeroClickTotali"] +1;
            
            $query = "UPDATE geec_campagneBanner SET numeroClickTotali = '$conteggioTotaleAggiornato', numeroClickOggi = '$conteggioGiornalieroAggiornato', dataUltimoClick='$dataClick' WHERE id=$idCampagna";
            $this->db->eseguiQueryScrittura($query);
        }
    }